% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DO.EvalIntegration.R
\name{DO.EvalIntegration}
\alias{DO.EvalIntegration}
\title{Do batch correction metrics for integration}
\usage{
DO.EvalIntegration(
  sce_object,
  label_key = "annotation",
  batch_key = "orig.ident",
  type_ = "embed",
  pcr_covariate = "orig.ident",
  pcr_n_comps = 30,
  scale = TRUE,
  verbose = FALSE,
  n_cores = 10,
  assay = "RNA",
  integration = "INTEGRATED.CCA",
  kBET = TRUE,
  cells.use = NULL,
  subsample = NULL,
  min_per_batch = NULL,
  all_scores_silhouette = FALSE,
  ...
)
}
\arguments{
\item{sce_object}{Seurat or SCE object.}

\item{label_key}{character, Annotation column}

\item{batch_key}{character, Sample column}

\item{type_}{character, default: "embed"}

\item{pcr_covariate}{character, covariate column for pcr}

\item{pcr_n_comps}{integer, number of components for pcr}

\item{scale}{boolean, default: TRUE}

\item{verbose}{boolean, defult: FALSE}

\item{n_cores}{integer, Number of cores used for calculations}

\item{assay}{character, Name of the assay the integration is saved in}

\item{integration}{character, Name of the integration to evaluate}

\item{kBET}{boolean, if kBET should be run}

\item{cells.use}{vector, named cells to use for kBET subsetting}

\item{subsample}{float, for starified subsampling,}

\item{min_per_batch}{integer, minimum number of cells per batch}

\item{all_scores_silhouette}{boolean,
define if all scores of silhouette return}

\item{...}{Additionally arguments for kBET}
}
\value{
DataFrame with score for the given integration
}
\description{
This function calculates different metrics to evaluate the
integration of scRNA expression matrices in a new dimension. Its a wrapper
function around scib batch correction metrics
}
\examples{
\dontrun{
sce_data <-
    readRDS(system.file("extdata", "sce_data.rds", package = "DOtools"))

DO.EvalIntegration(
    sce_object = sce_data,
    label_key = "annotation",
    batch_key = "orig.ident",
    type_ = "embed",
    pcr_covariate = "orig.ident",
    pcr_n_comps = 30,
    scale = TRUE,
    verbose = FALSE,
    n_cores = 10,
    assay = "RNA",
    integration = "INTEGRATED.CCA",
    kBET = TRUE,
    cells.use = NULL,
    subsample = NULL,
    min_per_batch = NULL,
    all_scores_silhouette = FALSE
)
}
}
\author{
Mariano Ruz Jurado
}
