# DOtools <img src="man/figures/LogoDoTools.png" align="right" width="240"/>

<!-- badges: start -->

<!-- [![BioC status](https://www.bioconductor.org/shields/build/release/bioc/DOtools.svg)](https://bioconductor.org/checkResults/release/bioc-LATEST/DOtools) -->

<!-- [![BioC dev status](https://www.bioconductor.org/shields/build/devel/bioc/DOtools.svg)](https://bioconductor.org/checkResults/devel/bioc-LATEST/DOtools) -->

[![Issues](https://img.shields.io/github/issues/MarianoRuzJurado/DOtools)](https://github.com/MarianoRuzJurado/DOtools/issues) [![Stars](https://img.shields.io/github/stars/MarianoRuzJurado/DOtools?style=flat&logo=github&color=yellow)](https://github.com/MarianoRuzJurado/DOtools/stargazers)

<!-- badges: end -->

## Overview

DOtools is a user-friendly R package designed to streamline common workflows in single-cell RNA sequencing (scRNA-seq) data analysis using the Seurat ecosystem and third-party tools such as scVI, CellTypist, and CellBender.
It provides high-level wrappers and visualisation utilities to help efficiently preprocess, analyze, and interpret single-cell data.

# <b> Installation </b>

DOtools is currently available through Bioconductor.
To install the package, start R and run:

``` ruby
install.packages("BiocManager")
BiocManager::install("DOtools")
```

## <b> Requirements </b>

Some functions in this package depend on Python packages or scripts. These functions use [basilisk](https://www.bioconductor.org/packages/release/bioc/html/basilisk.html) to create isolated environments, which are built using conda. 
As a result, a working conda installation is required. The DoTools pipeline was tested on Linux and MacOS and an example dataset with ~65k cells can be processed with a machine with at least 16GBs of RAM memomy and 5 CPUs.

## <b> Python package </b>

If you prefer python over R for data analysis, we also provide a python version of the DOtools package.
Please refer for the python version to: [DOtools_py](https://github.com/davidrm-bio/DOTools_py)

## <b> Contribution Guidelines </b>

Raising up an issue in this Github repository might be the fastest way of submitting suggestions and bugs.
Alternatively you can write an email: [ruzjurado\@med.uni-frankfurt.de](mailto:ruzjurado@med.uni-frankfurt.de)

## <b> Citation </b>

tba
