% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DO.UMAP.R
\name{DO.UMAP}
\alias{DO.UMAP}
\title{DO.UMAP}
\usage{
DO.UMAP(
  sce_object,
  FeaturePlot = FALSE,
  features = NULL,
  group.by = "seurat_clusters",
  umap_colors = NULL,
  text_size = 14,
  label = TRUE,
  order = TRUE,
  plot.title = TRUE,
  legend.position = "none",
  ...
)
}
\arguments{
\item{sce_object}{The seurat or SCE object}

\item{FeaturePlot}{Is it going to be a Dimplot or a FeaturePlot?}

\item{features}{features for Featureplot}

\item{group.by}{grouping of plot in DImplot and defines in featureplot the
labels}

\item{umap_colors}{what colors to use for UMAP, specify as vector}

\item{text_size}{Size of text}

\item{label}{label the clusters on the plot by group.by column}

\item{order}{Boolean determining whether to plot cells in order of
expression.}

\item{plot.title}{title for UMAP}

\item{legend.position}{specify legend position}

\item{...}{Further arguments passed to DimPlot or FeaturePlot function
from Seurat}
}
\value{
Plot with Refined colors and axes
}
\description{
Creates a polished UMAP plot using Seurat's DimPlot or
FeaturePlot functions. It allows customization of colors, labels, and other
plot elements for better visualisation. The function handles both
cluster-based visualisations and gene-based visualisations in a UMAP plot.
Ideal for refining UMAP outputs with added flexibility and enhanced
presentation.
}
\examples{
sce_data <-
    readRDS(system.file("extdata", "sce_data.rds", package = "DOtools"))

DO.UMAP(
    sce_object = sce_data,
    group.by = "seurat_clusters"
)

DO.UMAP(
    sce_object = sce_data,
    FeaturePlot = TRUE,
    features = c("BAG2", "CD74")
)

}
\author{
Mariano Ruz Jurado
}
