% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing_filtering_reduction.R
\name{pca_irlba_for_sparseMatrix}
\alias{pca_irlba_for_sparseMatrix}
\title{Run sparse PCA using irlba SVD}
\usage{
pca_irlba_for_sparseMatrix(x, n_comp, work = 3 * n_comp)
}
\arguments{
\item{x}{A sparse normalized matrix (features x cells)}

\item{n_comp}{The number of principal components to keep}

\item{work}{Working subspace dimension, larger values can speed convergence
at the cost of more memory use.}
}
\value{
The rotated data, e.g. the cells x PC column in case of sc data.
}
\description{
This function allows to run a PCA using IRLBA Singular Value Decomposition
in a fast & memory efficient way. The increamental Lanczos bidiagonalisation
algorithm allows to keep the matrix sparse as the "loci" centering is
implicit.
The function then multiplies by the approximate singular values (svd$d) in
order to get more importance to the first PCs proportionnally to their
singular values. This step is crucial for downstream approaches, e.g. UMAP or
T-SNE.
}
