% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_functions.R
\name{colors_scExp}
\alias{colors_scExp}
\title{Adding colors to cells & features}
\usage{
colors_scExp(
  scExp,
  annotCol = "sample_id",
  color_by = "sample_id",
  color_df = NULL
)
}
\arguments{
\item{scExp}{A SingleCellExperiment Object}

\item{annotCol}{Column names to color}

\item{color_by}{If specifying color_df, column names to color}

\item{color_df}{Color data.frame to specify which color for which condition}
}
\value{
A SingleCellExperiment with additionnal "color" columns in colData
}
\description{
Adding colors to cells & features
}
\examples{
data("scExp")
scExp = colors_scExp(scExp,annotCol = c("sample_id",
"total_counts"),
 color_by =  c("sample_id","total_counts"))

#Specific colors using a manually created data.frame :
color_df = data.frame(sample_id=unique(scExp$sample_id),
 sample_id_color=c("red","blue","green","yellow"))
scExp = colors_scExp(scExp,annotCol="sample_id",
color_by="sample_id",color_df=color_df)

}
