% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetal_germcells_mean_methylation.R
\name{fetal_germcells_mean_methylation}
\alias{fetal_germcells_mean_methylation}
\title{Promoter methylation of any gene in fetal germ cells}
\usage{
fetal_germcells_mean_methylation(
  genes = NULL,
  include_CTP = FALSE,
  values_only = FALSE
)
}
\arguments{
\item{genes}{\code{character} naming the selected genes. The default
value, \code{NULL}, takes all CT (specific) genes.}

\item{include_CTP}{\code{logical(1)} If \code{TRUE}, CTP genes are included.
(\code{FALSE} by default).}

\item{values_only}{\code{logical(1)}, \code{FALSE} by default. If \code{TRUE}, the
function will return the methylation values in all samples
instead of the heatmap.}
}
\value{
Heatmap of mean promoter methylation of any gene in normal tissues.
If \code{values_only = TRUE}, a SummarizeExperiment with methylation values is
returned instead.
}
\description{
Plots a heatmap of mean promoter methylation levels of
any genes in fetal germ cells, using WGSB data from "Dissecting the
epigenomic dynamics of human fetal germ cell development at single-cell
resolution" (Li et al. 2021). Methylation levels in tissues correspond
to the mean methylation of CpGs located in range of 1000 pb upstream and
500 pb downstream from gene TSS.
}
\examples{
fetal_germcells_mean_methylation()
fetal_germcells_mean_methylation(c("MAGEA1", "MAGEA3", "MAGEA4", "MAGEC2"))
}
