% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_qc.R
\name{plot_correlation_heatmap}
\alias{plot_correlation_heatmap}
\title{Plot a Correlation Heatmap}
\usage{
plot_correlation_heatmap(
  mat,
  min.color = "#FF0000",
  max.color = "#0000FF",
  legend.title = "Pearson Corr.",
  plot.title = "Correlation Matrix"
)
}
\arguments{
\item{mat}{A matrix containing the correlation values.}

\item{min.color}{Character scalar for the hexadecimal color code for
the minimum values in the heatmap.}

\item{max.color}{Character scalar for the hexadecimal color code for
the maximum values in the heatmap.}

\item{legend.title}{Character scalar for title of the legend.}

\item{plot.title}{Character scalar for title of the plot.}
}
\value{
A Heatmap object.
}
\description{
This function creates a heatmap using ComplexHeatmap to display the correlation values
in a matrix. The color of each cell in the heatmap is determined by the
corresponding correlation value, using a color ramp that ranges from the
minimum value color to a maximum value color.
}
\examples{
library(CRISPRball)
norm.counts <- read.delim(system.file("extdata", "escneg.count_normalized.txt",
    package = "CRISPRball"
), check.names = FALSE)
norm.counts <- as.matrix(norm.counts[, c(-1, -2)])
norm.counts.log <- log2(norm.counts + 1)
cor.mat <- cor(norm.counts.log)
plot_correlation_heatmap(cor.mat)
}
\author{
Jared Andrews
}
