% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biocBuildReport.R
\name{biocBuildReport}
\alias{biocBuildReport}
\title{Tidy Bioconductor build report results}
\usage{
biocBuildReport(
  version = BiocManager::version(),
  pkgType = c("software", "data-experiment", "data-annotation", "workflows"),
  stage.timings = FALSE
)
}
\arguments{
\item{version}{\code{character(1)} or \code{package_version} indicating the
\emph{Bioconductor} version (e.g., "3.22"). Defaults to the "current version"
provided by \code{BiocManager::version()}. The keywords "release" and "devel"
are also accepted.}

\item{pkgType}{\code{character()} The type of packages for which to get
information for. Values can be one or more of the following:
\itemize{
\item \code{software}: Software packages
\item \code{data-experiment}: Experiment data packages
\item \code{data-annotation}: Annotation data packages
\item \code{workflows}: Workflow packages
}}

\item{stage.timings}{\code{logical(1)} Whether to include the start, end, and
elapsed time for each build, check, install stage from each building in
the result (default: FALSE)}
}
\value{
A \code{tbl_df} object with columns pkg, version,
author, commit, date, node, stage, and result.
}
\description{
The online Bioconductor build reports
are great for humans to look at, but
they are not easily computable. This function
scrapes HTML and text files available
from the build report online pages to generate
a tidy data frame version of the build report.
}
\examples{

# Set the stage--what version of Bioc am I using?
BiocManager::version()

latest_build <- biocBuildReport()
head(latest_build)

}
