% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biocBuildEmail.R
\name{biocBuildEmail}
\alias{biocBuildEmail}
\alias{sentHistory}
\title{Create and copy e-mail package notification template to clipboard}
\usage{
biocBuildEmail(
  pkg,
  version = c("release", "devel"),
  PS = character(1L),
  dry.run = TRUE,
  to = NULL,
  cc = NULL,
  bcc = NULL,
  emailTemplate = templatePath(),
  core.name = NULL,
  core.email = NULL,
  core.id = NULL,
  textOnly = FALSE,
  resend = FALSE,
  verbose = FALSE,
  credFile = "~/.blastula_creds"
)

sentHistory()
}
\arguments{
\item{pkg}{\code{character(1)} The name of the package in trouble}

\item{version}{\code{character()} A vector indicating which version of Bioconductor
the package is failing in (either 'release' or 'devel'; defaults to both)}

\item{PS}{\code{character(1)} Postscript, an additional note to the recipient of
the email (i.e., the package maintainer)}

\item{dry.run}{\code{logical(1)} Display the email without sending to the recipient.
It only works for HTML email reports and ignored when \code{textOnly=TRUE}}

\item{to}{\code{character()} A vector of email addresses serving as primary
recipients for the message. For secondary recipients, use the \code{cc} and
\code{bcc} arguments.}

\item{cc, bcc}{\code{character()} A vector of email addresses for sending the message
as a carbon copy or blind carbon copy.}

\item{emailTemplate}{\code{character(1)} The path to the email template Rmd file as
obtained by \code{templatePath()}. A custom template can be provided as file
path.}

\item{core.name}{\code{character(1)} The full name of the core team member}

\item{core.email}{\code{character(1)} The Roswell Park email of the core team
member}

\item{core.id}{\code{character(1)} The internal identifier for the Roswell employee.
This ID usually matches \verb{^[A-Z]\{2\}[0-9]\{5\}} for more recent identifiers.}

\item{textOnly}{\code{logical(1)} Whether to return the text of the email only.
This avoids the use of the 'blastula' package and adds the text to the
system clipboard if the \code{clipr} package is installed (default: FALSE)}

\item{resend}{\code{logical(1)} Whether to force a resend of the email}

\item{verbose}{\code{logical(1)} Whether to output full email information from
'smtp_send' (when \code{dry.run} is \code{FALSE} and 'blastula' is installed)}

\item{credFile}{\code{character(1)} An optional file generated by the
\code{blastula::create_smtp_creds_file} function containing email
authentication information (default: "~/.blastula_creds"). See
\code{?biocBuildEmail} details.}
}
\value{
A character string of the email
}
\description{
The \code{biocBuildEmail} function provides a template for notifying
maintainers of errors in the Bioconductor Build System (BBS). This
convenience function returns the body of the email from a template within the
package and provides a copy in the clipboard.
}
\details{
The \code{credFile} argument is a convenience for avoiding password entry
at every instance an email is sent. If the default file
\verb{~/.blastula_creds} does not exist, the user will be prompted for
authorization information. Currently it is configured to emails for the
core-team:
\preformatted{
        blastula::create_smtp_creds_file(
            file = "~/.blastula_creds",
            user = "user.email@domain.org",
            host = "smtp.office365.com",
            port = 587,
            use_ssl = TRUE
        )
    }
}
\section{sentHistory}{
 Check the history of emails sent
}

